//=============================================================================
// Cross - used as pickup to claim a monsters soul after beeing killed
//=============================================================================
class MH2_Pickup_Cross extends HealthVial;

#exec obj load file=..\Textures\eol.utx package=eol

#exec mesh import mesh=MH2_Cross anivfile=Models\MH2_Cross_a.3d datafile=Models\MH2_Cross_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=MH2_Cross x=0 y=0 z=0
#exec mesh sequence mesh=MH2_Cross seq=All startframe=0 numframes=1

#exec meshmap new meshmap=MH2_Cross mesh=MH2_Cross
#exec meshmap scale meshmap=MH2_Cross x=0.10742 y=0.10742 z=0.21484

var int LifeTime;

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

function PlayPickupMessage(Pawn Other)
{
	Other.ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local int HealMax;
		
		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			Info_PRI(PlayerPawn(Other).PlayerReplicationInfo).Souls += 1;
			PlayPickupMessage(PlayerPawn(Other));
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}
	}
}

defaultproperties
{
     PickupMessage="You have claimed a soul!"
     ItemName="Cross"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'MH2_Cross'
     PickupSound=Sound'UnrealShare.Generic.RespawnSound'
     Mesh=Mesh'MH2_Cross'
     ScaleGlow=2.000000
     CollisionRadius=20.000000
     CollisionHeight=27.500000
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'eol.estone22'
     LifeTime=30

}
